function [outputArg1,outputArg2] =PLVinHGsites(SimplyNameT)
%UNTITLED11 此处提供此函数的摘要
%   此处提供详细说明

conditions={'NA','NU','HA','LU'};
plv_condi={};
for i_condi=1:length(conditions)
    plv_subs=[];
    for i_sub=1:length(Cri_Chan)
        SimplyName=SimplyNameT{i_sub};
        workpath=['E:\Software\brainstorm_db\Protocol01\data\',SimplyName,'\',...
            conditions{i_condi},'_bipolar_2\'];
        temp=dir([workpath,'timefreq_connectn_plvt_*']);
        fileName=temp.name;
        plvMatrix_lr=load([workpath,fileName]);
        data_plv1 = bst_memory('GetConnectMatrix',plvMatrix_lr);
        [~,ChanAdr]=ismember(plvMatrix_lr.RowNames,Cri_Chan(i_sub).HG);
        temp_ChanAdr=find(ChanAdr);
        if ~isempty(ChanAdr)


            plv_temp1=data_plv1(temp_ChanAdr,:,:,1);  % chan X chan X time X freqband, theta
            plv_temp2=squeeze(mean(plv_temp1,2));
            plv_subs=[plv_subs;plv_temp2];
            plv_temp3=mean(plv_temp2,1);
%             figure
%             plot(plvMatrix_lr.Time,plv_temp2);
%             xlim([-0.2,1.2]);
%             legend on
%             title(SimplyName)
        end
    end
  plv_condi{1,i_condi}=plv_subs;
  plv_condi{2,i_condi}=conditions{i_condi};
end



divTime=-200:1299;
AvgPowerT=[];
 for i_condi=1:length(plv_condi)
   AvgPowerT(:,:,i_condi)=plv_condi{1,i_condi}(:,plvMatrix_lr.Time>=-0.201); %NA/NU/HA/LU
 end
baseline=mean(AvgPowerT(:,divTime<0,:),[2 3]);
AvgPowerT=AvgPowerT-baseline;
SEM=squeeze(std(AvgPowerT,0,1)./sqrt(size(AvgPowerT,1)-1))';
Avg=squeeze(mean(AvgPowerT,1))';

 figure
    plot(divTime,AvgPowerT(:,:,1),'Color',[1 0 0 0.2]);
    hold on
    plot(divTime,AvgPowerT(:,:,2),'Color',[0 0 1 0.2]);
            xlim([-200 800]);
            legend off

    plot(divTime,Avg(1,:),'Color','r','LineWidth',2);
    plot(divTime,Avg(2,:),'Color','b','LineWidth',2);       
            title('PLV change in PFC HG sites')


%     SEM=smoothdata(SEM,2,"movmean",50);
%     Avg=smoothdata(Avg,2,"movmean",50);

axlim=[-1.5*(abs(min(Avg,[],'all'))),...
    1.2*max(Avg,[],'all')];
axRange=0.02*(axlim(2)-axlim(1));
LineColor={[1 0 0],[0,0,1],[1 0.75 0.8],[0.54  0.824  1.0]};
figure;
    LowEdge=Avg-SEM;
    UpEdge=Avg+SEM;
    for j=1:size(AvgPowerT,3)  % channelxtimexcondition
        hold on;
        LE=LowEdge(j,:);
        HE=UpEdge(j,:);
        xconf = [divTime divTime(end:-1:1)] ;%构造正反向的x值，作为置信区间的横坐标值
     
yconf = [LE HE(end:-1:1)];%构造y方向的上下范围，作为置信区间的纵坐标值
        p = fill(xconf,yconf,LineColor{1,j});%定义填充区间
        p.EdgeColor = LineColor{1,j};%定义区间边界的填充颜色，此处不设置
        p.LineStyle='none';
        alpha(0.35)
    end

    ptemp=[];
    hold on
    for j=1:size(AvgPowerT,3)
        p=plot(divTime,Avg(j,:),'LineWidth',2);
      
        p.Color=LineColor{1,j};
        ptemp{j}=p;
    end
    xlim([-200 800])

    ax=gca;
    ax.FontSize=15;
    ax.LineWidth=1.5;
    box off
    xlabel('Time from Cue Onset (ms)');
    ylabel('Averaged Change of PLV');
    xline(0,'k--','LineWidth',1.5);
    xline(650,'k--','LineWidth',1.5);
%     ylim([-5 80]);
 ylim(axlim)
    %ttest
    [~,p_sub]=ttest(AvgPowerT(:,:,1),AvgPowerT(:,:,2),'Dim',1);
    pmap=p_sub(:,divTime>=0 & divTime<=650,:);
    %*****************************多重比较校正
    StatThreshOptions.pThreshold = 0.01;
    StatThreshOptions.Correction = 'fdr';
    StatThreshOptions.Control    = [1 2];
    [pmask1, corr_p] = bst_stat_thresh(pmap, StatThreshOptions);   % Benjamini朒ochberg 1995
    %**************************************
    DivIndexT1=[];
    RTepoch=[];
    i=1;
    k=1;
    DivIndexT1{1,k}=strfind(pmask1(i,:,k),ones(1,DivCri));
    %         DivIndexT1{1,k}=find(pmask1(i,:,k)~=0);  %感兴趣时间内不等于0；
    DivSegIndex1=find(diff(DivIndexT1{1,k})~=1);    %速度索引点做差分，找出不连续的点，切分为多段
    if isempty(DivIndexT1{1,k})
        Latency(k,i)=NaN;
        RTepochT{k,i}=[];
    else
        DivSegIndex2=[DivIndexT1{1,k}(1,1),DivIndexT1{1,k}(DivSegIndex1+1);...
            [DivIndexT1{1,k}(DivSegIndex1),DivIndexT1{1,k}(end)]+DivCri-1];%由于变量Adtemp2时间从0开始且采样率为1000（1ms对应一个数据点），所以偷懒省去换算，此处行列为每段反应起止时间；
        RTepoch=divTime(DivSegIndex2+200);
        if numel(RTepoch)==2        %bug，只有2个数时matlab自动存为行向量；
            RTepoch=RTepoch';
        end
        RTepochT{k,i}=RTepoch;      %把每个比较条件的RT阶段都存入元胞
        Latency(k,i)=RTepoch(1);
    end

    %         if ~isempty(RTepochT{k,i})
    %
    %             for i_rt1=1:size(RTepochT{k,i},2)
    %                 %             v2=[RTepochT{k,i}(1,i_rt1),-80;RTepochT{k,i}(2,i_rt1),-80;RTepochT{k,i}(2,i_rt1),80;RTepochT{k,i}(1,i_rt1),80];
    %                 %             patch('Faces',f,'Vertices',v2,'EdgeColor',[1 0.75 0.8],'FaceColor','none','LineWidth',1,'LineStyle',':');
    %                 patch([RTepochT{k,i}(1,i_rt1),RTepochT{k,i}(2,i_rt1),RTepochT{k,i}(2,i_rt1),RTepochT{k,i}(1,i_rt1)],[-20 -20 150 150],0.7*[1 1 1],'FaceAlpha',.3,'EdgeColor',[1 1 1]);
    %
    %             end
    %             text(RTepochT{k,i}(1),0,num2str(RTepochT{k,i}(1)));
    %         end
    line(RTepochT{k,i},[axlim(1)+axRange axlim(1)+axRange],'LineWidth',4,'Color','k')
    text(mean(RTepochT{k,i}(:,1)),axlim(1)+2*axRange,'**','HorizontalAlignment','center','FontSize'...
        ,15)
    hold off
    title(['n=',num2str(size(AvgPowerT,1)),' sites'])
    outputPath='E:\DATA_SEEG\汇总结果\';
    saveas(gcf,[outputPath,'PopulationResult_PLV'],'fig')
    saveas(gcf,[outputPath,'PopulationResult_PLV'],'tif')

    VideoWriter
    writeVideo

   
